require( "scripts/style.lua" );

SliderFont = {
  standardFont,
  13,
  BlackColor
};

SliderMinMaxFont = {
  standardFont,
  10,
  BlackColor
};

TitleFont = {
  standardFont,
  40,
  BlackColor
};

ygap = 80; -- was 40;
sfxslider_y = 120;
musicslider_y = sfxslider_y + ygap;
voxslider_y = musicslider_y + ygap;
walkslider_y = voxslider_y + ygap;
talkslider_y = walkslider_y + ygap;
toggle_y = 350;	-- was 175
toggle_h = 30;
slider_text_offset_y = -25;
slider_x = 90;
slide_bar_x_offset = 40;
volume_image_offset_x = 5;
volume_image_offset_y = 4;
minmax_text_offset_x = 5;
minmax_text_offset_y = 20;
max_text_offset_x = 200;

OPTIONSSPEC =
{
	image = "backgrounds/largedialog",
	mask = exists("backgrounds/largedialog.mask.png");
	x = kCenter+5,
	y = kCenter-5,
	
	TOptions
	{
		x=20,y=0,w=kMax-40,h=kMax,
		
		Text
		{
			font = TitleFont,
			name = "title",
			x=kCenter,y=35,w=kMax ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "options"
		};
		--[[
		Bitmap
		{
			image = "buttons/name_plate",
			mask = exists("buttons/name_plate.mask.png"),
			x = slider_x,
			y= sfxslider_y+slider_text_offset_y
		};
		--]]
		Text
		{
			font = SliderFont,
			name = "sfx",
			x = slider_x+12,
			y = sfxslider_y+slider_text_offset_y,
			w=100,
			h=20,
			flags = kVAlignCenter,
			label = "SLIDER_sfxlevel"
		};
		--[[
		Bitmap
		{
			image = "buttons/name_plate",
			mask = exists("buttons/name_plate.mask.png"),
			x = slider_x,
			y= musicslider_y+slider_text_offset_y
		};
		--]]
		Text
		{
			font = SliderFont,
			name = "music",
			x=slider_x+12,
			y=musicslider_y+slider_text_offset_y,
			w=100,
			h=20,
			flags = kVAlignCenter,
			label = "SLIDER_musiclevel"
		};
		--[[
		Bitmap
		{
			name = "voxnameplate",
			image = "buttons/name_plate",
			mask = exists("buttons/name_plate.mask.png"),
			x = slider_x,
			y= voxslider_y+slider_text_offset_y
		};
		--]]
		Text
		{
			font = SliderFont,
			name = "vox",
			x = slider_x+12,
			y = voxslider_y+slider_text_offset_y,
			w = 100,
			h = 20,
			flags = kVAlignCenter,
			label = "SLIDER_voxlevel"
		};
--[[
		Text
		{
			font = SliderFont,
			name = "walk",
			x = slider_x, y = walkslider_y+slider_text_offset_y,w=100, h = 50,
			flags = kVAlignCenter,
			label = "SLIDER_walkspeed"
		};

		Text
		{
			font = SliderFont,
			name = "talk",
			x = slider_x, y = talkslider_y+slider_text_offset_y,w=100, h = 50,
			flags = kVAlignCenter,
			label = "SLIDER_talkspeed"
		};
--]]

		SetStyle(CheckboxButtonStyle),			
		Button{
			name="fullscreen",
			x=kCenter-60,
			y=toggle_y,
			h = toggle_h,
			w=90,
			label="fullscreen",

			command = function()
				if (ToggleFullScreen() == false) then
					DisplayDialog { 
						"scripts/ok.lua", 
						body = "screenswitchfailed",
						title = "playground" 
					};
				end
			end
			
		};
		
		Button{
			name="mutebox",
			x=kCenter+50,
			y=toggle_y,
			h = toggle_h,
			w=50,
			label="mutesound",

			command =
				function()
					ToggleSoundMute();
				end
		};

		SetStyle(ThinButtonStyle),
		Button
		{
			x = kCenter-60,
			y = kMax-71,
			name="back",
			label="back",
			type = kPush,
			command = function()
				SaveVolumes();
				StartClose(); -- PopModal("optionsmenu");
			end
		},
		
		Button
		{
			x = kCenter+60,
			y = kMax-71,
			name="credits",
			label="credits",
			type = kPush,
			command =
				function()
					DoModal("scripts/credits.lua");
				end
		},

		SetStyle(SliderStyle),
		
		Bitmap
		{
			image = "buttons/volume_image",
			mask = exists("buttons/volume_image.mask.png"),
			x = slider_x+volume_image_offset_x,
			y = sfxslider_y+volume_image_offset_y,
		},
		
		TSlider
		{
			name="sfxlevelslider",
			x = slider_x+slide_bar_x_offset,
			y = sfxslider_y,
			w = 230,
		};
		
		Text
		{
			font = SliderMinMaxFont,
			x = slider_x+slide_bar_x_offset+minmax_text_offset_x,
			y = sfxslider_y+minmax_text_offset_y,
			w = 50,
			h = 20,
			flags = kVAlignCenter,
			label = "min",
		};
		
		Text
		{
			font = SliderMinMaxFont,
			x = slider_x+slide_bar_x_offset+minmax_text_offset_x+max_text_offset_x,
			y = sfxslider_y+minmax_text_offset_y,
			w = 50,
			h = 20,
			flags = kVAlignCenter,
			label = "max",
		};
		
		Bitmap
		{
			image = "buttons/volume_image",
			mask = exists("buttons/volume_image.mask.png"),
			x = slider_x+volume_image_offset_x,
			y = musicslider_y+volume_image_offset_y,
		},
		
		TSlider
		{
			name="musiclevelslider",
			x = slider_x+slide_bar_x_offset,
			y = musicslider_y,
			w = 230,
		};
		
		Text
		{
			font = SliderMinMaxFont,
			x = slider_x+slide_bar_x_offset+minmax_text_offset_x,
			y = musicslider_y+minmax_text_offset_y,
			w = 50,
			h = 20,
			flags = kVAlignCenter,
			label = "min",
		};
		
		Text
		{
			font = SliderMinMaxFont,
			x = slider_x+slide_bar_x_offset+minmax_text_offset_x+max_text_offset_x,
			y = musicslider_y+minmax_text_offset_y,
			w = 50,
			h = 20,
			flags = kVAlignCenter,
			label = "max",
		};
		
		Bitmap
		{
			name = "voximage",
			image = "buttons/volume_image",
			mask = exists("buttons/volume_image.mask.png"),
			x = slider_x+volume_image_offset_x,
			y = voxslider_y+volume_image_offset_y,
		},
		
		TSlider
		{
			name = "voxlevelslider",
			x = slider_x+slide_bar_x_offset,
			y = voxslider_y,
			w =   230,
		};
		
		Text
		{
			name = "voxmintext",
			font = SliderMinMaxFont,
			x = slider_x+slide_bar_x_offset+minmax_text_offset_x,
			y = voxslider_y+minmax_text_offset_y,
			w = 50,
			h = 20,
			flags = kVAlignCenter,
			label = "min",
		};
		
		Text
		{
			name = "voxmaxtext",
			font = SliderMinMaxFont,
			x = slider_x+slide_bar_x_offset+minmax_text_offset_x+max_text_offset_x,
			y = voxslider_y+minmax_text_offset_y,
			w = 50,
			h = 20,
			flags = kVAlignCenter,
			label = "max",
		};
		--TSlider	{ name = "walkspeedslider", x = slider_x,	y = walkslider_y + 10,	w = 210, };
		--TSlider	{ name = "talkspeedslider", x = slider_x,	y = talkslider_y + 10,	w = 210, };
	},
};

MakeDialog
{
	-- Name the modal dialog
	name = "optionsmenu",
	tTransitionWindow
	{
		x = 0, y = 0, w = kMax, h = kMax, 
		speed_in = slide_speed_in, speed_out = slide_speed_out, accel_in = slice_accel_in, accel_out = slide_accel_out,
		Bitmap(OPTIONSSPEC)
	}
}

-- localized builds may not have voice
EnableWindow("voxlevelslider", IsVoiceEnabled());
EnableWindow("voximage", IsVoiceEnabled());
EnableWindow("voxmintext", IsVoiceEnabled());
EnableWindow("voxmaxtext", IsVoiceEnabled());
--EnableWindow("voxnameplate", IsVoiceEnabled());
EnableWindow("vox", IsVoiceEnabled());
